// Mobile Navigation Toggle
const navToggle = document.getElementById("navToggle")
const navMenu = document.getElementById("navMenu")

navToggle.addEventListener("click", () => {
  navMenu.classList.toggle("active")
})

// Close mobile menu when clicking on a link
document.querySelectorAll(".nav-link").forEach((link) => {
  link.addEventListener("click", () => {
    navMenu.classList.remove("active")
  })
})

// Smooth scrolling for navigation links
document.querySelectorAll('a[href^="#"]').forEach((anchor) => {
  anchor.addEventListener("click", function (e) {
    e.preventDefault()
    const target = document.querySelector(this.getAttribute("href"))
    if (target) {
      target.scrollIntoView({
        behavior: "smooth",
        block: "start",
      })
    }
  })
})

// Navbar background on scroll
window.addEventListener("scroll", () => {
  const navbar = document.querySelector(".navbar")
  if (window.scrollY > 100) {
    navbar.style.background = "rgba(0, 0, 0, 0.8)"
  } else {
    navbar.style.background = "rgba(0, 0, 0, 0.2)"
  }
})

// Scroll animations
const observerOptions = {
  threshold: 0.1,
  rootMargin: "0px 0px -50px 0px",
}

const observer = new IntersectionObserver((entries) => {
  entries.forEach((entry) => {
    if (entry.isIntersecting) {
      entry.target.classList.add("visible")
    }
  })
}, observerOptions)

// Add fade-in class to elements and observe them
document.addEventListener("DOMContentLoaded", () => {
  const elementsToAnimate = [".service-card", ".specialty-item", ".value-item", ".section-header"]

  elementsToAnimate.forEach((selector) => {
    document.querySelectorAll(selector).forEach((el) => {
      el.classList.add("fade-in")
      observer.observe(el)
    })
  })
})

// Parallax effect for floating elements
window.addEventListener("scroll", () => {
  const scrolled = window.pageYOffset
  const floating1 = document.querySelector(".floating-1")
  const floating2 = document.querySelector(".floating-2")

  if (floating1) {
    floating1.style.transform = `translateY(${scrolled * 0.5}px)`
  }
  if (floating2) {
    floating2.style.transform = `translateY(${scrolled * -0.3}px)`
  }
})

// Button hover effects
document.querySelectorAll(".btn-primary, .btn-secondary").forEach((button) => {
  button.addEventListener("mouseenter", function () {
    this.style.transform = "translateY(-2px)"
  })

  button.addEventListener("mouseleave", function () {
    this.style.transform = "translateY(0)"
  })
})

// Service card hover effects
document.querySelectorAll(".service-card").forEach((card) => {
  card.addEventListener("mouseenter", function () {
    this.style.transform = "translateY(-10px) scale(1.02)"
  })

  card.addEventListener("mouseleave", function () {
    this.style.transform = "translateY(0) scale(1)"
  })
})

// Specialty item hover effects
document.querySelectorAll(".specialty-item").forEach((item) => {
  item.addEventListener("mouseenter", function () {
    const icon = this.querySelector(".specialty-icon")
    if (icon) {
      icon.style.transform = "scale(1.15) rotate(5deg)"
    }
  })

  item.addEventListener("mouseleave", function () {
    const icon = this.querySelector(".specialty-icon")
    if (icon) {
      icon.style.transform = "scale(1) rotate(0deg)"
    }
  })
})

// Add typing effect to hero title
function typeWriter(element, text, speed = 100) {
  let i = 0
  element.innerHTML = ""

  function type() {
    if (i < text.length) {
      element.innerHTML += text.charAt(i)
      i++
      setTimeout(type, speed)
    }
  }

  type()
}

// Initialize typing effect when page loads
window.addEventListener("load", () => {
  setTimeout(() => {
    const heroTitle = document.querySelector(".hero-title")
    if (heroTitle) {
      const originalHTML = heroTitle.innerHTML
      heroTitle.style.opacity = "1"
      // Keep the original HTML with spans for gradient effects
    }
  }, 500)
})

// Add glitch effect to logo on hover
document.querySelectorAll(".nav-logo, .footer-logo").forEach((logo) => {
  logo.addEventListener("mouseenter", function () {
    this.style.animation = "glitch 0.3s ease-in-out"
  })

  logo.addEventListener("animationend", function () {
    this.style.animation = ""
  })
})

// Add CSS for glitch animation
const style = document.createElement("style")
style.textContent = `
    @keyframes glitch {
        0% { transform: translate(0); }
        20% { transform: translate(-2px, 2px); }
        40% { transform: translate(-2px, -2px); }
        60% { transform: translate(2px, 2px); }
        80% { transform: translate(2px, -2px); }
        100% { transform: translate(0); }
    }
`
document.head.appendChild(style)

// Add particle effect (optional enhancement)
function createParticle() {
  const particle = document.createElement("div")
  particle.style.position = "fixed"
  particle.style.width = "4px"
  particle.style.height = "4px"
  particle.style.background = "linear-gradient(45deg, #06b6d4, #8b5cf6)"
  particle.style.borderRadius = "50%"
  particle.style.pointerEvents = "none"
  particle.style.zIndex = "9999"
  particle.style.opacity = "0.7"

  const x = Math.random() * window.innerWidth
  const y = Math.random() * window.innerHeight

  particle.style.left = x + "px"
  particle.style.top = y + "px"

  document.body.appendChild(particle)

  // Animate particle
  const animation = particle.animate(
    [
      { transform: "translate(0, 0) scale(1)", opacity: 0.7 },
      {
        transform: `translate(${(Math.random() - 0.5) * 200}px, ${(Math.random() - 0.5) * 200}px) scale(0)`,
        opacity: 0,
      },
    ],
    {
      duration: 3000,
      easing: "ease-out",
    },
  )

  animation.onfinish = () => {
    particle.remove()
  }
}

// Create particles periodically
setInterval(createParticle, 2000)

console.log("🚀 TechForge website loaded successfully!")
console.log("💡 Inteligencia, Código y Propósito")
